/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser.DisplayPort;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.BadPacketException;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortDataBlock;
import com.quantumdata.busmon.parser.DisplayPort.DisplayPortMessage;
import com.quantumdata.busmon.parser.Packet;
import com.quantumdata.busmon.parser.PacketTrace;
import com.quantumdata.busmon.parser.PacketTraceType;
import com.quantumdata.busmon.parser.Parser;
import com.quantumdata.busmon.parser.TypeConverter;
import java.io.IOException;
import java.io.ObjectInput;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;

public class DisplayPortPacketTrace
extends PacketTrace {
    private static final long serialVersionUID = 1L;
    private static String[] sColumnNames = new String[]{"NUMBER", "<HTML><CENTER>DELTA TIME</CENTER><BR>(HH:MM:SS:MICROS)</HTML>", "TYPE", "DETAILS"};
    private static String[] nonHtmlColumnNames = new String[]{"NUMBER", "DELTA TIME", "TYPE", "DETAILS"};
    private static Packet previousFilteredPacket = null;

    public DisplayPortPacketTrace() {
        this.traceType = PacketTraceType.DISPLAYPORT_PACKET_TRACE_TYPE;
    }

    public DisplayPortPacketTrace(ObjectInput objectInput) throws ClassNotFoundException, IOException, BadPacketException {
        super(objectInput);
        this.traceType = PacketTraceType.DISPLAYPORT_PACKET_TRACE_TYPE;
    }

    public int getColumnCount() {
        return sColumnNames.length;
    }

    public String getColumnName(int n) {
        return sColumnNames[n];
    }

    public String getNonHtmlColumnName(int n) {
        return nonHtmlColumnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        return this.getValueAt(n, n2, false);
    }

    public String getValueAt(int n, int n2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (n < this.filteredVector.size()) {
            Packet packet = (Packet)this.filteredVector.get(n);
            switch (n2) {
                case 0: {
                    stringBuffer.append(Integer.toString(packet.getOrdinal()));
                    break;
                }
                case 1: {
                    int n3;
                    if (MainAppFrame.deltaTimeAction.isTrue()) {
                        n3 = Sniffer.window.jPacketTable.getSelectedRow();
                        if (n3 == -1) {
                            if (n == 0) {
                                stringBuffer.append(this.GetTimestampAsString(0L));
                                break;
                            }
                            stringBuffer.append(this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(0)));
                            break;
                        }
                        if (n >= n3) {
                            stringBuffer.append(this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n3)));
                            break;
                        }
                        stringBuffer.append("-" + this.GetTimestampDifferenceAsString((Packet)this.filteredVector.get(n3), packet));
                        break;
                    }
                    if (packet.getTimestamp() == 0L) {
                        stringBuffer.append("");
                        break;
                    }
                    if (n == 0) {
                        stringBuffer.append(this.GetTimestampAsString(0L));
                        break;
                    }
                    for (n3 = n - 1; n3 != -1 && ((Packet)this.filteredVector.get(n3)).getTimestamp() == 0L; --n3) {
                    }
                    if (n3 == -1) {
                        stringBuffer.append(this.GetTimestampAsString(0L));
                        break;
                    }
                    stringBuffer.append(this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n3)));
                    break;
                }
                case 2: {
                    stringBuffer.append(packet.getDirection());
                    break;
                }
                case 3: {
                    stringBuffer.append(packet.getDetails());
                    break;
                }
                default: {
                    stringBuffer.append("???");
                }
            }
            if (!bl) {
                String string2 = "<html><span style='color:#ff0000;'>";
                if (!packet.isError()) {
                    boolean bl2 = this.isEDID(n);
                    boolean bl3 = this.isHDCP(n);
                    boolean bl4 = this.isHotPlug(n);
                    string2 = bl2 ? "<html><span style='color:#808000;'>" : (bl3 ? "<html><span style='color:#00c000;'>" : (bl4 ? "<html><span style='color:#008080;'>" : "<html><span style='color:#0c000c;'>"));
                }
                string = string2 + stringBuffer.toString();
            } else {
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private boolean isHotPlug(int n) {
        Packet packet = (Packet)this.filteredVector.get(n);
        String string = packet.getDataBlock().getType();
        return string != null && string.equalsIgnoreCase("HOTPLUG");
    }

    public String GetTimestampAsString(long l) {
        long l2 = l * 10L;
        String string = TypeConverter.getDisplayPortTimestampString(l2);
        return string;
    }

    public String GetTimestampAsString(Packet packet) {
        long l = packet.getTimestamp() * 10L;
        String string = TypeConverter.getDisplayPortTimestampString(l);
        return string;
    }

    public String GetTimestampDifferenceAsString(Packet packet, Packet packet2) {
        long l = packet.getTimestamp() * 10L;
        long l2 = packet2.getTimestamp() * 10L;
        return TypeConverter.getDisplayPortTimestampString(l - l2);
    }

    private boolean isEDID(int n) {
        boolean bl = false;
        Packet packet = (Packet)this.filteredVector.get(n);
        if (packet.getDataBlock() instanceof DisplayPortDataBlock) {
            Packet packet2;
            DisplayPortDataBlock displayPortDataBlock = (DisplayPortDataBlock)packet.getDataBlock();
            if (DisplayPortPacketTrace.meetsEDIDCriteria(displayPortDataBlock.aMessage)) {
                bl = true;
            } else if (!DisplayPortPacketTrace.isEDIDRequest(displayPortDataBlock.aMessage) && n > 0 && (packet2 = (Packet)this.filteredVector.get(n - 1)).getDataBlock() instanceof DisplayPortDataBlock) {
                DisplayPortDataBlock displayPortDataBlock2 = (DisplayPortDataBlock)packet2.getDataBlock();
                if (DisplayPortPacketTrace.meetsEDIDCriteria(displayPortDataBlock2.aMessage)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean isHDCP(int n) {
        boolean bl = false;
        Packet packet = (Packet)this.filteredVector.get(n);
        if (packet.getDataBlock() instanceof DisplayPortDataBlock) {
            Packet packet2;
            DisplayPortDataBlock displayPortDataBlock = (DisplayPortDataBlock)packet.getDataBlock();
            if (DisplayPortPacketTrace.meetsHDCPCriteria(displayPortDataBlock.aMessage)) {
                bl = true;
            } else if (!DisplayPortPacketTrace.isHDCPRequest(displayPortDataBlock.aMessage) && n > 0 && (packet2 = (Packet)this.filteredVector.get(n - 1)).getDataBlock() instanceof DisplayPortDataBlock) {
                DisplayPortDataBlock displayPortDataBlock2 = (DisplayPortDataBlock)packet2.getDataBlock();
                if (DisplayPortPacketTrace.meetsHDCPCriteria(displayPortDataBlock2.aMessage)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private static boolean meetsEDIDCriteria(DisplayPortMessage displayPortMessage) {
        int n;
        boolean bl = false;
        if (displayPortMessage != null && DisplayPortPacketTrace.isEDIDRequest(displayPortMessage) && ((n = displayPortMessage.getAddress()) == 160 || n == 96)) {
            bl = true;
        }
        return bl;
    }

    private static boolean meetsHDCPCriteria(DisplayPortMessage displayPortMessage) {
        boolean bl = false;
        if (displayPortMessage != null && DisplayPortPacketTrace.isHDCPRequest(displayPortMessage) && displayPortMessage.getAddress() >= 425984) {
            bl = true;
        }
        return bl;
    }

    private static boolean isEDIDRequest(DisplayPortMessage displayPortMessage) {
        int n;
        boolean bl = false;
        if (displayPortMessage != null && ((n = displayPortMessage.getMessageType()) == 4 || n == 3 || n == 5)) {
            bl = true;
        }
        return bl;
    }

    private static boolean isHDCPRequest(DisplayPortMessage displayPortMessage) {
        int n;
        boolean bl = false;
        if (displayPortMessage != null && ((n = displayPortMessage.getMessageType()) == 1 || n == 2)) {
            bl = true;
        }
        return bl;
    }

    public void updateTimeColumnName(JTable jTable) {
        if (MainAppFrame.deltaTimeAction.isTrue()) {
            jTable.getColumnModel().getColumn(1).setHeaderValue("<HTML><CENTER>CUMULATIVE TIME</CENTER><BR>(HH:MM:SS:MICROS)</HTML>");
        } else {
            jTable.getColumnModel().getColumn(1).setHeaderValue("<HTML><CENTER>DELTA TIME</CENTER><BR>(HH:MM:SS:MICROS)</HTML>");
        }
    }

    public StringBuffer saveToHtml() {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n<head>\n");
        stringBuffer.append("<title>ACA Program Version 1.41</title>\n");
        stringBuffer.append("<style>\n");
        stringBuffer.append("table{font-weight: bold; font-size: 10px; color: #000000; font-family: verdana, arial, helvetica, sans-serif}\n");
        stringBuffer.append("td{border-style: 1px solid black; }\n");
        stringBuffer.append("td.event{color: black;  background-color: #00C0F7;}\n");
        stringBuffer.append("td.hdcp{color: black;  background-color: #71FFBD;}\n");
        stringBuffer.append("td.edid{color: black;  background-color: #FFD471;}\n");
        stringBuffer.append("td.lt{color: black;  background-color: #ffffff;}\n");
        stringBuffer.append("td.error{color: black;  background-color: #FF0000;}\n");
        stringBuffer.append("td.headerinfoleft{color: white; background-color: #000000;}\n");
        stringBuffer.append("td.headerinforight{border: 1px solid black;}\n");
        stringBuffer.append("th{border-bottom: 1px solid black; color: white; background-color: #000000}\n");
        stringBuffer.append("</style>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<table>\n");
        stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">ACA PROGRAM VERSION</td>\n");
        stringBuffer.append("<td class=\"headerinforight\">1.41</td>\n");
        stringBuffer.append("</tr>\n");
        stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">REPORT DATE</td>\n");
        stringBuffer.append("<td class=\"headerinforight\">" + new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z").format(new Date()) + "</td>\n");
        stringBuffer.append("</tr>\n");
        if (Parser.instrument.isConnected()) {
            object = "verf?";
            String string = Parser.instrument.sendCmd((String)object).getResponse();
            String string2 = "verg?";
            String string3 = Parser.instrument.sendCmd(string2).getResponse();
            if (string != null && string.length() > 0) {
                stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">FIRMWARE VERSION</td>\n");
                stringBuffer.append("<td class=\"headerinforight\">" + string + "</td>\n");
                stringBuffer.append("</tr>\n");
            }
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">GATEWARE VERSION</td>\n");
                stringBuffer.append("<td class=\"headerinforight\">" + string3 + "</td>\n");
                stringBuffer.append("</tr>\n");
            }
        }
        stringBuffer.append("</table>\n<p>\n");
        stringBuffer.append("<table>\n");
        stringBuffer.append("  <tr>\n");
        object = Sniffer.window.jPacketTable;
        int n2 = ((JTable)object).getColumnCount();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("<th>\n");
            stringBuffer.append(this.getColumnName(n).toUpperCase());
            stringBuffer.append("</th>\n");
        }
        stringBuffer.append("<th align=\"left\">RAW DATA</th>");
        stringBuffer.append("</tr>");
        n = ((JTable)object).getRowCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("<tr>\n");
            for (int j = 0; j < n2 + 1; ++j) {
                stringBuffer.append(this.getHtmlDecoratedValue(i, j));
            }
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("</table></body></html>");
        return stringBuffer;
    }

    private String getHtmlDecoratedValue(int n, int n2) {
        Packet packet = (Packet)this.filteredVector.get(n);
        String string = "";
        switch (n2) {
            case 0: {
                string = Integer.toString(packet.getOrdinal());
                break;
            }
            case 1: {
                int n3;
                if (MainAppFrame.deltaTimeAction.isTrue()) {
                    n3 = Sniffer.window.jPacketTable.getSelectedRow();
                    if (n3 == -1) {
                        if (n == 0) {
                            string = this.GetTimestampAsString(0L);
                            break;
                        }
                        string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(0));
                        break;
                    }
                    if (n >= n3) {
                        string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n3));
                        break;
                    }
                    string = "-" + this.GetTimestampDifferenceAsString((Packet)this.filteredVector.get(n3), packet);
                    break;
                }
                if (packet.getTimestamp() == 0L) {
                    string = "";
                    break;
                }
                if (n == 0) {
                    string = this.GetTimestampAsString(0L);
                    break;
                }
                for (n3 = n - 1; n3 != -1 && ((Packet)this.filteredVector.get(n3)).getTimestamp() == 0L; --n3) {
                }
                if (n3 == -1) {
                    string = this.GetTimestampAsString(0L);
                    break;
                }
                string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n3));
                break;
            }
            case 2: {
                string = packet.getDirection();
                break;
            }
            case 3: {
                string = packet.getDetails();
                break;
            }
            case 4: {
                string = packet.getHexString();
            }
        }
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        string2 = packet.isError() ? "<td class=\"error\">" : (packet.isEDID() ? "<td class=\"edid\">" : (packet.isDDCCI() ? "<td class=\"ddcci\">" : (packet.isHDCP() ? "<td class=\"hdcp\">" : (packet.isEvent() ? "<td class=\"event\">" : "<td class=\"lt\">"))));
        stringBuffer.append(string2);
        if (string.length() > 0) {
            stringBuffer.append(string + "</td>\n");
        } else {
            stringBuffer.append("&nbsp;</td>\n");
        }
        return stringBuffer.toString();
    }

    private boolean checkPacketFilters(Packet packet) {
        boolean bl = packet.isError() || !MainAppFrame.errorsOnlyAction.isTrue();
        boolean bl2 = packet.isDDCCI() && MainAppFrame.filterDDCCIAction.isTrue();
        bl2 = bl2 || packet.isEDID() && MainAppFrame.filterEDIDAction.isTrue();
        bl2 = bl2 || packet.isEvent() && MainAppFrame.filterEventsAction.isTrue();
        bl2 = bl2 || packet.isHDCP() && MainAppFrame.filterHDCPAction.isTrue();
        bl2 = bl2 || packet.isLT() && MainAppFrame.filterLTAction.isTrue();
        bl2 = bl2 || packet.isOther() && MainAppFrame.filterOtherAction.isTrue();
        return bl && bl2;
    }

    protected boolean addFilteredPacket(Packet packet) {
        Packet packet2 = packet;
        if (packet.getDataBlock() == null) {
            return false;
        }
        if (packet.getDataBlock() instanceof DisplayPortDataBlock) {
            if (packet.getDirection().equals("REQUEST")) {
                previousFilteredPacket = packet;
            } else if (packet.getDirection().equals("REPLY")) {
                packet2 = previousFilteredPacket != null ? previousFilteredPacket : packet;
            }
        }
        if (this.checkPacketFilters(packet2)) {
            this.filteredVector.add(packet);
            return true;
        }
        return false;
    }
}

